/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.palette;

import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.toolkit.design.palette.VWBaseStepPalettePanel;
import filenet.vw.toolkit.design.palette.VWScrollableIconViewPanel;
import filenet.vw.toolkit.design.palette.VWStepPaletteWrapper;
import filenet.vw.toolkit.design.palette.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.VWModelessDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

class VWModelessPaletteDialog
extends VWModelessDialog {
    private static final int WINDOW_WIDTH = 465;
    private static final int WINDOW_HEIGHT = 395;
    private static final int MARGIN_SIZE = 50;
    private static final int OFFSET_SIZE = 5;
    private VWScrollableIconViewPanel m_iconViewPanel = null;

    public VWModelessPaletteDialog(VWDesignerCoreData designerCoreData) {
        super(designerCoreData.getParentFrame(), designerCoreData.getSessionInfo());
        this.setTitle(VWResource.s_stepPaletteDialogTitle);
        if (!this.updateWindowPosition("step_palette_dialog_location", "step_palette_dialog_size")) {
            this.updateWindowPosition(465, 395, 0);
        }
        this.createControls(designerCoreData);
    }

    public void setVisible(boolean bShow) {
        boolean bWasVisible = this.isVisible();
        if (bWasVisible && !bShow) {
            this.saveWindowPosition("step_palette_dialog_location", "step_palette_dialog_size");
        }
        super.setVisible(bShow);
        if (!bShow) {
            this.m_parentContainer.setEnabled(true);
        }
    }

    protected void displayPalettes(VWStepPaletteWrapper[] stepPalettes) {
        if (this.m_iconViewPanel != null) {
            this.m_iconViewPanel.displayPalettes(stepPalettes);
        }
        if (stepPalettes == null || stepPalettes.length == 0) {
            this.setVisible(false);
        } else {
            int nDeltaY;
            Dimension dialogSize = this.getSize();
            Dimension panelSize = this.getContentPane().getSize();
            Dimension preferredSize = this.m_iconViewPanel.getPreferredSize();
            int nDeltaX = panelSize.width - preferredSize.width;
            if (nDeltaX > 50) {
                dialogSize.width -= nDeltaX - 5;
            }
            if ((nDeltaY = panelSize.height - preferredSize.height) > 50) {
                dialogSize.height -= nDeltaY - 5;
            }
            this.setSize(dialogSize);
        }
    }

    protected void setStepPalettePanel(VWBaseStepPalettePanel stepPalettePanel) {
        if (this.m_iconViewPanel != null) {
            this.m_iconViewPanel.setStepPalettePanel(stepPalettePanel);
        }
    }

    protected void releaseReferences() {
        this.setVisible(false);
        if (this.m_iconViewPanel != null) {
            Container parent = this.m_iconViewPanel.getParent();
            if (parent != null && parent instanceof JViewport) {
                parent.removeComponentListener(this.m_iconViewPanel);
            }
            this.m_iconViewPanel.releaseReferences();
            this.m_iconViewPanel = null;
        }
        this.removeAll();
    }

    private void createControls(VWDesignerCoreData designerCoreData) {
        this.getContentPane().setLayout(new BorderLayout());
        this.m_iconViewPanel = new VWScrollableIconViewPanel();
        this.getContentPane().add((Component)new JScrollPane(this.m_iconViewPanel), "Center");
        Container parent = this.m_iconViewPanel.getParent();
        if (parent != null && parent instanceof JViewport) {
            parent.addComponentListener(this.m_iconViewPanel);
        }
    }
}

